/*
 * Decompiled with CFR 0.152.
 */
package panther.util.unicon;

import java.util.ArrayList;
import java.util.List;

public class ThreadUtil {
    public static void sleep(long l) throws InterruptedException {
        Thread.sleep(l);
    }

    public static void safeSleep(long l) {
        try {
            ThreadUtil.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void guaranteedSleep(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l2 > System.currentTimeMillis()) {
            ThreadUtil.safeSleep(l2 - System.currentTimeMillis());
        }
    }

    public static String getSenderString() {
        StackTraceElement stackTraceElement = ThreadUtil.getSender(1);
        return stackTraceElement == null ? null : stackTraceElement.toString();
    }

    public static List getSenders(int n, int n2) {
        ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>(n2 * 3 / 2);
        StackTraceElement[] stackTraceElementArray = ThreadUtil.getStack();
        int n3 = 3 + n;
        int n4 = Math.min(stackTraceElementArray.length, n3 + n2);
        for (int i = n3; i < n4; ++i) {
            arrayList.add(stackTraceElementArray[i]);
        }
        return arrayList;
    }

    public static StackTraceElement getSender(int n) {
        StackTraceElement[] stackTraceElementArray = ThreadUtil.getStack();
        if (stackTraceElementArray == null || stackTraceElementArray.length < 3 + n) {
            return null;
        }
        return stackTraceElementArray[3 + n];
    }

    public static StackTraceElement[] getStack() {
        Throwable throwable = null;
        try {
            throw new Error("Generate Stack Trace");
        }
        catch (Throwable throwable2) {
            if (throwable2 instanceof ThreadDeath) {
                throw (ThreadDeath)throwable2;
            }
            throwable = throwable2;
            return throwable == null ? null : throwable.getStackTrace();
        }
    }
}

